function Figure7(relyaw)
visAllAnglePhase(relyaw.CountPerPhase);
end

function visAnglePhase(dat, con, phase)
fld_con = fieldnames(dat);
c = find(strcmp(fld_con,con));
data = dat.(fld_con{c});
fld_map = fieldnames(data);
fld_phase = fieldnames(data.(fld_map{1}));
p = find(strcmp(fld_phase,phase));
linesty = {'-',':','--'};
titlestr = {'Without second vehicle - Yielding', 'Without second vehicle - Non-yielding','With second vehicle - Yielding', 'With second vehicle - Non-yielding'};
colorstr = {[0 0.45 0.74]; [0.85 0.33 0.10]; [0.93 0.69 0.13]};
hold on
for m=1:length(fld_map)
    
    val=data.(fld_map{m}).(fld_phase{p}).val;
    freq=data.(fld_map{m}).(fld_phase{p}).freq;

    freq=freq./(1-freq(end)/100);
    %[Figure7data_pedestrianhead.all.ND_Y.map0.freq Figure7data_pedestrianhead.ind.ND_Y.map0.freq(1:end-1)./(1-Figure7data_pedestrianhead.ind.ND_Y.map0.freq(end)/100)]  % these two vectors are equal

    plot(val,freq, linesty{m},'LineWidth',2,'Color',colorstr{m});
    yl = plot([-500 500],[max(freq(1:end-1)) max(freq(1:end-1))],linesty{m},'Color',colorstr{m},'LineWidth',3);
    yl.Annotation.LegendInformation.IconDisplayStyle = 'off';
end
xlabel('Gaze yaw angle (deg)','FontSize',15,'FontWeight','bold');
ylabel('Frequency','FontSize',15,'FontWeight','bold');
set(gca,'XDir','reverse')
set(gca,'FontSize',15);
title(titlestr{c},'FontSize',15,'FontWeight','bold');
xlim([-200 50])
yticks(0:2:30);
ylim([0 23]);
grid on;
legend('baseline','LTY', 'LATY','Location','northeast');
end

function visAllAnglePhase(data)
fld_con = fieldnames(data);
figure
i = 0;
for j= 1:2
    for c=[j, j+2]
        fld_phase = fieldnames(data.(fld_con{c}).map0);
        for p = 2
            i = i + 1;
            subplot(2,2,i);
            visAnglePhase(data, fld_con{c}, fld_phase{p});
        end
    end
end
end
